<?xml version="1.0" encoding="utf-8"?>
<!--
Copyright:
	Copyright © 2023 by each of the following organizations:
	1.  Aerospace, Security and Defence Industries Association of Europe - ASD.
	2.  Ministries of Defence of the member countries of ASD.

	Limitations of Liability:

	1.  This material is provided "As Is" and neither ASD nor any person who has contributed to the creation, revision or maintenance of the material makes any representations or warranties, express or implied, including but not limited to, warranties of merchantability or fitness for any particular purpose.
	2.  Neither ASD nor any person who has contributed to the creation, revision or maintenance of this material shall be liable for any direct, indirect, special or consequential damages or any other liability arising from any use of this material.
	3.  Revisions to this document may occur after its issuance.  The user is responsible for determining if revisions to the material contained in this document have occurred and are applicable. 
-->

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="toc">
		<html>
			<link rel="STYLESHEET" type="text/css" href="../css/styles.css"/>
			<script language="javascript" src="../js/functions.js"/>
			
			<body>
				<p class="title">
					<xsl:text>S1000D Issue </xsl:text>
					<span id="issue"/>
					<span id="dash"></span>
					<span id="inwork"/>
					<br/>
					<!--<xsl:text>Data Dictionary</xsl:text>-->
					<span id="tocTitle" />
				</p>
				<p class="toctitle"><xsl:text>Choose a category:</xsl:text></p>
				<p>
					<table border="0" width="100%">
<!--						<tr>
						<td colspan="3">
							<span class="toctitle"><xsl:text>Choose a category:</xsl:text></span>
						</td>
						</tr>-->
						<tr align="center">
						<td>							
							<a href="javascript:launchDD('elem');">
								<b><xsl:text>Elements</xsl:text></b>
							</a>
						</td>
						<td>							
							<a href="javascript:launchDD('att');">
								<b><xsl:text>Attributes</xsl:text></b>
							</a>
						</td>
						<td>							
							<a href="javascript:launchDD('schema');">
								<b><xsl:text>XML Schema</xsl:text></b>
							</a>
						</td>
						</tr>
					</table>
				</p>
			</body>
			<!--<script>
				document.getElementById("popupTitle").innerHTML = localStorage.title;
				document.getElementById("issue").innerHTML = localStorage.issue;
				document.getElementById("inwork").innerHTML = localStorage.inwork;
				document.getElementById("date").innerHTML = localStorage.date;
				if (localStorage.inwork!=''){
				document.getElementById("dash").innerHTML = '-';
				}
			</script>-->
			<script>				
				document.getElementById("tocTitle").innerHTML = localStorage.title;
				document.getElementById("issue").innerHTML = localStorage.issue;
				if (localStorage.inwork!=''){
				document.getElementById("dash").innerHTML = '-';
				}
				document.getElementById("inwork").innerHTML = localStorage.inwork;
			</script>
		</html>
	</xsl:template>
</xsl:stylesheet>