<?xml version="1.0" encoding="utf-8"?>
<!--
Copyright:
	Copyright © 2023 by each of the following organizations:
	1.  Aerospace, Security and Defence Industries Association of Europe - ASD.
	2.  Ministries of Defence of the member countries of ASD.

	Limitations of Liability:

	1.  This material is provided "As Is" and neither ASD nor any person who has contributed to the creation, revision or maintenance of the material makes any representations or warranties, express or implied, including but not limited to, warranties of merchantability or fitness for any particular purpose.
	2.  Neither ASD nor any person who has contributed to the creation, revision or maintenance of this material shall be liable for any direct, indirect, special or consequential damages or any other liability arising from any use of this material.
	3.  Revisions to this document may occur after its issuance.  The user is responsible for determining if revisions to the material contained in this document have occurred and are applicable. 
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">	
	<xsl:output method = "html"/>
	<xsl:include href="parameter.xsl"/>
	<xsl:template match="header">
		<html>
			<head>
				<meta charset="utf-8"/>
				<xsl:if test="$DEBUG='true'">
					<meta http-equiv="expires" content="0"/>
				</xsl:if>
				<link rel="STYLESHEET" type="text/css" href="../css/styles.css"/>
				<script language="javascript" src="../js/functions.js"/>
			</head>
			<body class="header">				
				<div class="navbar">
					<a class="navbarlogo" href="http://www.s1000d.org" target="_blank"><img class="headerlogo" SRC="../img/s1000d.svg" alt="S1000D logo" /></a> 
					<xsl:if test="$DEBUG='true'">
						<a class="navbarlogo" href="info.html" onclick="return PopupCenter(this,'Info',500,700)" title="open |Info| in popup"><img class="headerlogo" SRC="../img/info32.png" alt="Info" /></a>
					</xsl:if>					 
					<a href="contact.html" onclick="return PopupCenter(this,'Contact',500,400)" title="open |Contact| in popup">Contact</a>      
					<a href="knownissues.html" onclick="return PopupCenter(this,'Known Issues',900,800)" title="open |Known Issues| in popup">Known Issues</a>    
					<a href="disclaimer.html" onclick="return PopupCenter(this,'Disclaimer', 500,600)" title="open |Disclaimer| in popup">Disclaimer</a>
					<a href="about.html" onclick="return PopupCenter(this,'About', 500,600)" title="open |about| in popup">About</a>
					<a href="javascript:home();">Home</a>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>